<?php

//login
add_action('wp_ajax_nopriv_poker_login', 'poker_login_handler');
if (!function_exists('poker_login_handler')) {
    function poker_login_handler()
    {
        if (wp_verify_nonce($_POST['_wpnonce'])) {
            $player_id = filter_input(INPUT_POST, 'player_id');
            $password = filter_input(INPUT_POST, 'password');
            if ($player_id && $password) {
                $creds = array(
                    'user_login'    => $player_id,
                    'user_password' => $password,
                );
                $user = wp_signon($creds, is_ssl());

                if (is_wp_error($user)) {
                    $message = $user->get_error_message();
                    $message = str_replace('Lost your password?', '', $message);
                    wp_send_json_error([
                        'message' => $message
                    ]);
                } else {
					//return wp_redirect('www.google.com');
                    wp_send_json_success('OK');
                }
            }
        }
        wp_send_json_error();
    }
}

add_action('wp_ajax_nopriv_poker_wp_nonce_field', 'poker_wp_nonce_field_handler');
add_action('wp_ajax_poker_wp_nonce_field', 'poker_wp_nonce_field_handler');
if (!function_exists('poker_wp_nonce_field_handler')) {
    function poker_wp_nonce_field_handler()
    {
        wp_send_json_success([
            'success' => true,
            'html' => wp_nonce_field(-1, '_wpnonce', false, false)
        ]);
    }
}

//reset password send link
add_action('wp_ajax_nopriv_poker_password_reset_send', 'poker_password_reset_send_handler');
if (!function_exists('poker_password_reset_send_handler')) {
    function poker_password_reset_send_handler()
    {
        if (wp_verify_nonce($_POST['_wpnonce'])) {
            $out = [
                'message' => 'Email with password restore link has been sent'
            ];

            $login = filter_input(INPUT_POST, 'login');
            $found = get_user_by('email', $login) ?: get_user_by('login', $login);
            if ($found !== false) {
                $reset_key = get_password_reset_key($found);

                $user_login = $found->user_login;
                $reset_page_link = poker_get_template_page_link('template-page-password-restore.php');
                $reset_link = $reset_page_link . "?key=$reset_key&login=$user_login";

                $message = "Password Restore Link:\n$reset_link";
                wp_mail($found->user_email, 'Password Restore', $message);

                wp_send_json_success($out);
            } else {
                $out['message'] = 'User not exists';
            }
        }
        wp_send_json_error($out);
    }
}

//reset password create
add_action('wp_ajax_nopriv_poker_password_reset_create', 'poker_password_reset_create_handler');
if (!function_exists('poker_password_reset_create_handler')) {
    function poker_password_reset_create_handler()
    {
        $out = [];
        if (wp_verify_nonce($_POST['_wpnonce'])) {
            $out['message'] = '<strong>Password</strong> has beem changed';
            $user_login = filter_input(INPUT_POST, 'login');
            $reset_key = filter_input(INPUT_POST, 'key');
            $password = filter_input(INPUT_POST, 'password');
            $password_match = filter_input(INPUT_POST, 'confirm_password');
            
            $user = check_password_reset_key($reset_key, $user_login);

            if (is_wp_error($user)) {
                $out['message'] = $user->get_error_message();
            } else {
                if (strcmp($password, $password_match) === 0) {
                    wp_set_password($password, $user->ID);
                    wp_send_json_success($out);
                } else {
                    $out['message'] = 'Passwords should be equals';
                }
            }
        }

        wp_send_json_error($out);
    }
}

//?
add_action('wp_login', 'poker_user_pre_login_generate', 10, 2);
if (!function_exists(('poker_user_pre_login_generate'))) {
    function poker_user_pre_login_generate($user_login, $user)
    {
        $user_id = get_field('user_id', 'user_' . $user->ID);
        if (empty($user_id) == true) {
            $user_id = $user->ID;
            update_field('user_id', $user_id, 'user_' . $user->ID);
        }
    }
}
//? end


add_action('wp_ajax_nopriv_poker_search_profiles', 'poker_search_profiles_handler');
add_action('wp_ajax_poker_search_profiles', 'poker_search_profiles_handler');
if (!function_exists('poker_search_profiles_handler')) {
  function poker_search_profiles_handler()
    {
        global $wpdb;
        $out = [];
        if (wp_verify_nonce($_POST['_wpnonce'])) {
         //   $search =trim(filter_input(INPUT_POST, 'search'));
            $search =filter_input(INPUT_POST, 'search');

            if(is_numeric($search) == true)
            {
                $result = $wpdb->get_results("SELECT wp_user_id from poker_player where player_id='$search' " );
                $wp_user_id1=$result[0]->wp_user_id;
                $getData=$wpdb->get_results("SELECT ID,user_login from wpu0_users where ID='$wp_user_id1' " );
               // $result[0]->wp_user_id
               global $wp_user_by_id;
               global $wp_user_id;
               $wp_user_by_id=$getData[0]->ID;
               $wp_user_id=$getData;
               get_template_part('template-parts/loop/table', 'profile');
               $out['html'] = ob_get_clean();

               wp_send_json_success($out);
               // wp_send_json_success($getData);
            }
            else {

                $args = array(
                    
                    'search'         => "*$search*",
                    'search_columns' => array('user_login','display_name')
                   
                     
                );	
                $profiles_query = new WP_User_Query($args);

            ob_start();
            foreach ($profiles_query->results as $user) {
                global $wp_user;
                $wp_user = $user;
                get_template_part('template-parts/loop/table', 'profile');
            }
            $out['html'] = ob_get_clean();

            wp_send_json_success($out);
            }
			 
        }
        wp_send_json_error($out);
    }
}

add_action('wp_ajax_nopriv_poker_league_filter', 'poker_league_filter_handler');
add_action('wp_ajax_poker_league_filter', 'poker_league_filter_handler');
if (!function_exists('poker_league_filter_handler')) {
    function poker_league_filter_handler()
    {
        $out = [];
        $filters = $_POST['filter'];
        $sort = $_POST['sort'];
        $render_items_count = $_POST['view']['show'];

        $all_games_ids_sql = poker_Connector::connector()->getGamesByDate($filters['month'], $filters['year'], true); //all games from time period
        $game_players_ids = poker_Connector::connector()->getGamePlayersSortBy($all_games_ids_sql, $sort['field'], $sort['order'], $render_items_count, true);

        ob_start();
        foreach($game_players_ids as $player_data){
            global $player;
            $player = $player_data;
            get_template_part('template-parts/loop/table', 'league');
        }
        $out['html'] = ob_get_clean();

        wp_send_json_success($out);
    }
}